/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.ui.layout.components;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import org.betterx.ui.layout.components.CustomRenderComponent;
import org.betterx.ui.layout.components.render.RenderHelper;
import org.betterx.ui.layout.values.Rectangle;
import org.betterx.ui.layout.values.Size;
import org.betterx.ui.layout.values.Value;

@Environment(value=EnvType.CLIENT)
public class Image
extends CustomRenderComponent {
    protected Rectangle uvRect;
    public final class_2960 location;
    protected float alpha;
    protected Size resourceSize;

    public Image(Value width, Value height, class_2960 location) {
        this(width, height, location, new Size(16, 16));
    }

    public Image(Value width, Value height, class_2960 location, Size resourceSize) {
        super(width, height);
        this.location = location;
        this.uvRect = new Rectangle(0, 0, resourceSize.width(), resourceSize.height());
        this.resourceSize = resourceSize;
        this.alpha = 1.0f;
    }

    public Image setAlpha(float a) {
        this.alpha = a;
        return this;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public Image setUvRect(int left, int top, int width, int height) {
        this.setUvRect(new Rectangle(left, top, width, height));
        return this;
    }

    public Image setUvRect(Rectangle rect) {
        this.uvRect = rect;
        return this;
    }

    public Rectangle getUvRect() {
        return this.uvRect;
    }

    public Image setResourceSize(int width, int height) {
        return this.setResourceSize(new Size(width, height));
    }

    public Image setResourceSize(Size sz) {
        this.resourceSize = sz;
        return this;
    }

    public Size getResourceSize() {
        return this.resourceSize;
    }

    @Override
    public int getContentWidth() {
        return this.uvRect.width;
    }

    @Override
    public int getContentHeight() {
        return this.uvRect.height;
    }

    @Override
    protected void customRender(class_4587 stack, int mouseX, int mouseY, float deltaTicks, Rectangle bounds, Rectangle clipRect) {
        RenderHelper.renderImage(stack, 0, 0, bounds.width, bounds.height, this.location, this.resourceSize, this.uvRect, this.alpha);
    }

    @Override
    public boolean method_25405(double d, double e) {
        return false;
    }
}

